#include <stdio.h>
#include <windows.h>

#pragma comment(lib, "gdi32.lib")
#pragma comment(lib, "user32.lib")

typedef BYTE uchar;

#include "wmfdata.cpp"

//---------------------------------------------------------------------------
extern "C" const char copyr[] = "Copyright 2006 by Ilfak Guilfanov, ig@hexblog.com\0"
                                "http://www.hexblog.com";

static char tmp_name[MAX_PATH];
static bool silent = false;

//---------------------------------------------------------------------------
void error(const char *message)
{
  if ( !silent )
    MessageBox(NULL, message, NULL, MB_OK);
  ExitProcess(2);
}

//---------------------------------------------------------------------------
int WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR, int)
{
  char *cmdline = GetCommandLine();
  silent = cmdline != NULL && strstr(cmdline, "/SILENT") != NULL;
  if ( !silent )
    MessageBox(NULL,
             "This program checks your system against the WMF vulnerability.\n"
             "\n"
             "It does not do anything harmful to your computer and does not\n"
             "alter any files on it.\n"
             "\n"
             "When you press OK, the test results will be displayed on the screen.\n"
             "\n"
             "Copyright 2006 by Ilfak Guilfanov, http://www.hexblog.com",
             "WMF Vulnerability Checker v1.2",
             MB_OK);

  char path[1024];
  GetTempPath(sizeof(path), path);

  DWORD *silent_ptr = (DWORD *)(array + sizeof(array) - 10);
  *silent_ptr = silent;
  HMETAFILE h = SetMetaFileBitsEx(sizeof(array), (BYTE*)array);
  if ( h == NULL )
    error("ERROR: could not create metafile");

  RECT Rect; // rendering rectangle, anything will do
  Rect.left   = 0;
  Rect.top    = 0;
  Rect.bottom = 500;
  Rect.right  = 500;
  GetTempFileName(path, "ig", 0, tmp_name);
  HDC DC = CreateEnhMetaFile(NULL, tmp_name, &Rect, "Sample WMF");

  // PlayMetaFile crashes in the case of vulnerability
  PlayMetaFile(DC, h);
  DeleteFile(tmp_name);
  if ( !silent )
    MessageBox(NULL,
             "You system seems to be invulnerable to the WMF exploit.\n"
             "\n"
             "Please note that this program tries only one WMF exploit.\n"
             "In theory other vulnerabilities and exploits are possible,\n"
             "so stay vigilant and update your systems frequently!",
             "No vulnerability has been detected",
             MB_OK);
  return 0;
}
