<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- English Revision: 421100 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->
<!-- $LastChangedRevision: 2007072901 $ -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="configuring.xml.meta">

  <title>Fichiers de configuration</title>

<summary>
<p>Ce document d&eacute;crit les fichiers utilis&eacute;s pour configurer
le Serveur HTTP Apache.</p>
</summary>

  <section id="main">
    <title>Fichiers de configuration principaux</title>
    <related>
      <modulelist>
        <module>mod_mime</module>
      </modulelist>
      <directivelist>
        <directive module="core" type="section">IfDefine</directive>
        <directive module="core">Include</directive>
        <directive module="mod_mime">TypesConfig</directive>
      </directivelist>
    </related>

    <p>La configuration d'Apache est effectu&eacute;e en pla&ccedil;ant des <a
    href="mod/directives.html">directives</a> dans des fichiers de
    configuration au format texte. Le fichier de configuration principal se nomme
    en g&eacute;n&eacute;ral
    <code>httpd.conf</code>. La localisation de ce fichier est d&eacute;finie
    &agrave; la compilation, mais peut &ecirc;tre red&eacute;finie &agrave; l'aide de l'option
    de ligne de commande <code>-f</code>. En outre, d'autres fichiers de
    configuration peuvent &ecirc;tre ajout&eacute;s &agrave; l'aide de la directive
    <directive module="core">Include</directive>, et des caract&egrave;res de
    remplacement
    peuvent &ecirc;tre utilis&eacute;s pour inclure de nombreux fichiers de configuration.
    Des directives de tous types peuvent &ecirc;tre plac&eacute;es dans chacun de ces fichiers
    de configuration.  Les modifications dans les fichiers de configuration
    principaux ne sont prises en compte par Apache que lorsque le serveur
    est d&eacute;marr&eacute; ou red&eacute;marr&eacute;.</p>

    <p>Le serveur lit aussi un fichier contenant les types de document mime;
    ce fichier est d&eacute;fini par la directive <directive
    module="mod_mime">TypesConfig</directive>,
    et se nomme <code>mime.types</code> par d&eacute;faut.</p>
  </section>

  <section id="syntax">
    <title>Syntaxe des fichiers de configuration</title>

    <p>Les fichiers de configuration d'Apache contiennent une directive
    par ligne.
    On peut utiliser l'anti-slash "\" comme dernier caract&egrave;re d'une ligne
    pour indiquer que la directive continue &agrave; la ligne suivante.
    Il ne doit y avoir aucun caract&egrave;re ni espace entre l'anti-slash et
    la fin de la ligne.</p>

    <p>Les directives dans les fichiers de configuration ne sont pas
    sensibles &agrave; la casse, mais leurs arguments le sont souvent. Les lignes
    qui d&eacute;butent par le caract&egrave;re "#" sont interpr&eacute;t&eacute;es comme des
    commentaires, et sont ignor&eacute;es. Les commentaires ne doivent
    <strong>pas</strong> &ecirc;tre inclus dans une ligne apr&egrave;s une directive
    de configuration. Les lignes vides et les espaces pr&eacute;c&eacute;dant une directive
    sont ignor&eacute;s; vous pouvez par cons&eacute;quent indenter les directives
    afin d'am&eacute;liorer la lisibilit&eacute;.</p>

    <p>Vous pouvez v&eacute;rifier l'absence d'erreurs de syntaxe dans vos fichiers
    de configuration sans d&eacute;marrer le serveur &agrave; l'aide de la commande
    <code>apachectl configtest</code> ou de l'option de ligne de commande
    <code>-t</code>.</p>
  </section>

  <section id="modules">
    <title>Modules</title>

    <related>
      <modulelist>
        <module>mod_so</module>
      </modulelist>
      <directivelist>
        <directive module="core" type="section">IfModule</directive>
        <directive module="mod_so">LoadModule</directive>
      </directivelist>
    </related>

    <p>Apache est un serveur modulaire. Ceci implique que seules les
    fonctionnalit&eacute;s les plus courantes sont incluses dans le serveur de base.
    Les fonctionnalit&eacute;s &eacute;tendues sont fournies &agrave; l'aide de <a
    href="mod/">modules</a> qui peuvent &ecirc;tre charg&eacute;s dans Apache.
    Par d&eacute;faut, un jeu de <a
    href="mod/module-dict.html#Status">modules de base</a> est inclus dans le
    serveur &agrave; la compilation. Si le serveur est compil&eacute; de fa&ccedil;on &agrave; utiliser
    les <a href="dso.html">modules charg&eacute;s dynamiquement</a>,
    alors les modules peuvent &ecirc;tre compil&eacute;s s&eacute;par&eacute;ment et charg&eacute;s &agrave;
    n'importe quel moment &agrave; l'aide de la directive
    <directive module="mod_so">LoadModule</directive>.
    Dans le cas contraire, Apache doit &ecirc;tre recompil&eacute; pour ajouter ou
    supprimer des modules.
    Les directives de configuration peuvent &ecirc;tre incluses de mani&egrave;re
    conditionnelle selon la pr&eacute;sence ou l'absence d'un module particulier
    en les pla&ccedil;ant dans un bloc <directive
    module="core" type="section">IfModule</directive>.</p>

    <p>Pour voir quels modules ont &eacute;t&eacute; compil&eacute;s avec le serveur,
    vous pouvez utiliser l'option de ligne de commande <code>-l</code>.</p>
  </section>

  <section id="scope">
    <title>Port&eacute;e des directives</title>

    <related>
      <directivelist>
        <directive module="core" type="section">Directory</directive>
        <directive module="core" type="section">DirectoryMatch</directive>
        <directive module="core" type="section">Files</directive>
        <directive module="core" type="section">FilesMatch</directive>
        <directive module="core" type="section">Location</directive>
        <directive module="core" type="section">LocationMatch</directive>
        <directive module="core" type="section">VirtualHost</directive>
      </directivelist>
    </related>

    <p>Les directives plac&eacute;es dans les fichiers de configuration principaux
    s'appliquent au serveur dans son ensemble. Si vous souhaitez modifier la
    configuration d'une partie du serveur seulement, vous pouvez limiter la
    port&eacute;e de vos directives en les pla&ccedil;ant dans une section
    <directive module="core"
    type="section">Directory</directive>, <directive module="core"
    type="section">DirectoryMatch</directive>, <directive module="core"
    type="section">Files</directive>, <directive module="core"
    type="section">FilesMatch</directive>, <directive module="core"
    type="section">Location</directive>, ou <directive module="core"
    type="section">LocationMatch</directive>.
    Ces sections limitent le champ d'application des directives qu'elles
    contiennent &agrave; des URls ou des portions du syst&egrave;me de fichiers particuli&egrave;res.
    Elles peuvent aussi &ecirc;tre imbriqu&eacute;es, ce qui permet
    une configuration tr&egrave;s fine.</p>

    <p>Apache peut servir simultan&eacute;ment de nombreux sites web au travers des
    <a href="vhosts/">H&ocirc;tes Virtuels</a>. La port&eacute;e des directives peut ainsi
    &ecirc;tre limit&eacute;e en les pla&ccedil;ant dans des sections
    <directive module="core" type="section">VirtualHost</directive>,
    afin qu'elles ne s'appliquent qu'aux requ&ecirc;tes
    pour un site web particulier.</p>

    <p>Bien que la plupart des directives puissent &ecirc;tre plac&eacute;es dans
    chacune de ces sections, certaines d'entre elles n'ont aucun sens
    dans certains contextes.
    Par exemple, les directives qui contr&ocirc;lent la cr&eacute;ation des processus
    n'ont de sens que dans le contexte du serveur principal. Pour d&eacute;terminer
    quelles directives peuvent &ecirc;tre plac&eacute;es dans quelles sections, consultez
    le <a href="mod/directive-dict.html#Context">Contexte</a> de la
    directive. Pour plus d'informations, nous fournissons des d&eacute;tails dans
    <a href="sections.html">Comment fonctionnent les sections Directory,
    Location et Files</a>.</p>
  </section>

  <section id="htaccess">
    <title>Fichiers .htaccess</title>

    <related>
      <directivelist>
        <directive module="core">AccessFileName</directive>
        <directive module="core">AllowOverride</directive>
      </directivelist>
    </related>

    <p>Apache permet la gestion d&eacute;centralis&eacute;e de la configuration
    via des fichiers sp&eacute;ciaux plac&eacute;s dans l'arborescence du site web.
    Ces fichiers sp&eacute;ciaux se nomment en g&eacute;n&eacute;ral <code>.htaccess</code>,
    mais tout autre nom peut &ecirc;tre sp&eacute;cifi&eacute; &agrave; l'aide de la directive
    <directive module="core">AccessFileName</directive>.
    Les directives plac&eacute;es dans les fichiers <code>.htaccess</code>
    s'appliquent au r&eacute;pertoire dans lequel vous avez plac&eacute; le fichier,
    ainsi qu'&agrave; tous ses sous-r&eacute;pertoires.
    La syntaxe des fichiers <code>.htaccess</code> est la m&ecirc;me que celle
    des fichiers de configuration principaux. Comme les fichiers
    <code>.htaccess</code> sont lus &agrave; chaque requ&ecirc;te, les modifications de
    ces fichiers prennent effet imm&eacute;diatement.</p>

    <p>Pour d&eacute;terminer quelles directives peuvent &ecirc;tre plac&eacute;es
    dans les fichiers <code>.htaccess</code>, consultez le
    <a href="mod/directive-dict.html#Context">Contexte</a> de la
    directive. L'administrateur du serveur peut contr&ocirc;ler quelles
    directives peuvent &ecirc;tre plac&eacute;es dans les fichiers
    <code>.htaccess</code> en d&eacute;finissant la directive
    <directive module="core">AllowOverride</directive>
    dans les fichiers de configuration principaux.</p>

    <p>Pour plus d'informations sur les fichiers <code>.htaccess</code>,
    se r&eacute;f&eacute;rer au <a href="howto/htaccess.html">tutoriel .htaccess</a>.</p>
  </section>
</manualpage>
