<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- English Revision: 421100 -->
<!-- French translation : Lucien GENTIS -->
<!-- $LastChangedRevision: 2007070801 $ -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="mpm.xml.meta">

  <title>Modules multi-processus (MPMs)</title>

<summary>
<p>Ce document d&eacute;crit ce qu'est un Module Multi-Processus, ainsi
que la mani&egrave;re dont ces modules sont utilis&eacute;s par le serveur HTTP Apache.</p>
</summary>

<section id="introduction"><title>Introduction</title>

    <p>Le serveur HTTP Apache a &eacute;t&eacute; con&ccedil;u comme un serveur web puissant et
    flexible pouvant fonctionner sur une tr&egrave;s grande vari&eacute;t&eacute; de
    plateformes et toute une gamme d'environnements diff&eacute;rents. Plateformes
    diff&eacute;rentes et environnements diff&eacute;rents signifient souvent fonctionnalit&eacute;s
    diff&eacute;rentes, ou utilisation de diff&eacute;rentes m&eacute;thodes pour
    impl&eacute;menter la m&ecirc;me fonctionnalit&eacute; le plus efficacement possible.
    Apache s'est toujours accomod&eacute; d'une grande vari&eacute;t&eacute; d'environnements
    gr&acirc;ce &agrave; sa conception modulaire. Cette conception autorise le webmaster
    &agrave; choisir quelles fonctionnalit&eacute;s seront incluses
    dans le serveur en s&eacute;lectionnant les modules &agrave; charger soit &agrave; la
    compilation, soit &agrave; l'ex&eacute;cution.</p>

    <p>Apache 2.0 &eacute;tend cette conception modulaire aux fonctions les plus
    &eacute;l&eacute;mentaires d'un serveur web. Certains Modules Multi-Processus (MPMs)
    sont responsables de l'association aux ports r&eacute;seau de la machine,
    acceptent les requ&ecirc;tes, et se chargent de r&eacute;partir ces derni&egrave;res
    entre les diff&eacute;rents processus enfants.</p>

    <p>L'extension de la conception modulaire &agrave; ce niveau du serveur
    comporte deux avantages importants:</p>

    <ul>
      <li>Apache peut supporter plus proprement et efficacement une grande
      vari&eacute;t&eacute; de syst&egrave;mes d'exploitation. En particulier, la version Windows
      d'Apache est maintenant beaucoup plus efficace, depuis que
      <module>mpm_winnt</module> peut utiliser les fonctionnalit&eacute;s r&eacute;seau
      natives &agrave; la place de la couche POSIX utilis&eacute;e par
      Apache 1.3. Cet avantage s'&eacute;tend aussi aux syst&egrave;mes d'exploitation
      qui impl&eacute;mentent des MPMs sp&eacute;cialis&eacute;s.</li>

      <li>le serveur est plus &agrave; m&ecirc;me de r&eacute;pondre aux besoins d'un site
      particulier. Par exemple, les sites qui sont tr&egrave;s sollicit&eacute;s peuvent
      utiliser un MPM thread&eacute; comme
      <module>worker</module> ou <module>event</module>, tandis que les sites
      qui privil&eacute;gient la stabilit&eacute; ou la compatibilit&eacute; avec des logiciels
      plus anciens peuvent utiliser un module comme
      <module>prefork</module>.</li>
    </ul>

    <p>Du point de vue de l'utilisateur, les MPMs ne sont pas diff&eacute;rents des
    autres modules Apache. La principale diff&eacute;rence r&eacute;side dans le fait qu'un
    et un seul MPM &agrave; la fois doit &ecirc;tre charg&eacute; dans le serveur. La liste des
    MPMs disponibles est fournie dans <a href="mod/">module index page</a>.</p>

</section>

<section id="choosing"><title>Choisir un MPM</title>

    <p>Les MPMs doivent &ecirc;tre choisis &agrave; la configuration, et compil&eacute;s avec
    le serveur. Les compilateurs peuvent optimiser de nombreuses fonctions
    si les threads sont utilis&eacute;s, mais seulement s'ils savent que les threads
    sont utilis&eacute;s.</p>

    <p>Pour le choix proprement dit du MPM d&eacute;sir&eacute;, utiliser l'argument
      <code>--with-mpm=<em>NOM</em></code> du script
      <program>configure</program>. <em>NOM</em> est le nom
      du MPM d&eacute;sir&eacute;.</p>

    <p>Une fois le serveur compil&eacute;, il est possible de savoir quel MPM
    a &eacute;t&eacute; choisi &agrave; l'aide de la commande <code>./httpd -l</code>.
    Cette commande fournit la liste de tous les modules compil&eacute;s
    avec le serveur, y compris le MPM.</p>
</section>

<section id="defaults"><title>MPM par d&eacute;faut</title>

<p>La table suivante fournit la liste des MPMs par d&eacute;faut pour divers
syst&egrave;mes d'exploitation.  Il s'agit du MPM s&eacute;lectionn&eacute; si vous ne pr&eacute;cisez
pas un choix diff&eacute;rent &agrave; la compilation.</p>

<table>
<columnspec><column width=".2"/><column width=".2"/></columnspec>
<tr><td>BeOS</td><td><module>beos</module></td></tr>
<tr><td>Netware</td><td><module>mpm_netware</module></td></tr>
<tr><td>OS/2</td><td><module>mpmt_os2</module></td></tr>
<tr><td>Unix</td><td><module>prefork</module></td></tr>
<tr><td>Windows</td><td><module>mpm_winnt</module></td></tr>
</table>
</section>

</manualpage>
