<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- LastChangedRevision English document : 682363 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->
<!-- $LastChangedRevision: 2007101301 $ -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="new_features_2_2.xml.meta">

<title>Aper&ccedil;u des nouvelles fonctionnalit&eacute;s dans Apache 2.2</title>

<summary>
  <p>Ce document d&eacute;crit quelques uns des changements principaux entre
     les versions 2.0 et 2.2 du serveur HTTP Apache. Pour les
     nouvelles fonctionnalit&eacute;s ajout&eacute;es depuis la version 1.3, se
     r&eacute;f&eacute;rer au document
     <a href="new_features_2_0.html">2.0 new features</a>.</p>
</summary>

  <section id="core">
    <title>Am&eacute;liorations du syst&egrave;me de base</title>
    <dl>

      <dt>Authn/Authz</dt>
      <dd>Les modules d'authentification et d'autorisation int&eacute;gr&eacute;s
	ont &eacute;t&eacute; refondus. Le nouveau module
	<module>mod_authn_alias</module> permet de
	simplifier consid&eacute;rablement certaines configurations d'authentification.
          Voir <a href="#module">modification des noms de modules</a>,
	  et
	  <a href="#developer">les changements pour le d&eacute;veloppeur</a>
	  pour plus d'informations sur les cons&eacute;quences de ces
	  changements pour les utilisateurs et les d&eacute;veloppeurs de
	  modules.</dd>

      <dt>Mise en cache</dt>
      <dd><module>mod_cache</module>, <module>mod_disk_cache</module>, et
          <module>mod_mem_cache</module> ont subi de nombreuses
	  modifications, et l'on consid&egrave;re qu'ils ont maintenant atteint
	  un degr&eacute; de qualit&eacute; suffisant pour leur mise en production. Le programme
	  <program>htcacheclean</program> a &eacute;t&eacute; ajout&eacute; afin de rendre
	  plus propre la configuration du module
	  <module>mod_disk_cache</module>.</dd>

      <dt>Configuration</dt>
      <dd>L'agencement de la configuration par d&eacute;faut a &eacute;t&eacute; simplifi&eacute;
      	et modularis&eacute;. Les portions de configuration qui peuvent &ecirc;tre
	utilis&eacute;es pour activer des fonctionnalit&eacute;s courantes sont
	maintenant int&eacute;gr&eacute;es &agrave; Apache, et peuvent &ecirc;tre facilement
	ajout&eacute;es &agrave; la configuration principale du serveur.</dd>

      <dt>Arr&ecirc;t en douceur</dt>
      <dd>Les modules MPM <module>prefork</module>,
        <module>worker</module> et <module>event</module> permettent
	maintenant l'arr&ecirc;t en douceur de <program>httpd</program>
          au moyen du signal
          <a href="stopping.html#gracefulstop"><code>graceful-stop</code></a>.
	  La directive <directive module="mpm_common"
	  >GracefulShutdownTimeout</directive> a &eacute;t&eacute; ajout&eacute;e dans le but
	  de sp&eacute;cifier un d&eacute;lai optionnel, apr&egrave;s lequel
          <program>httpd</program> s'arr&ecirc;tera quel que soit le statut
          des requ&ecirc;tes en cours.</dd>

      <dt>Mise en oeuvre du proxy</dt>
      <dd>Le nouveau module <module>mod_proxy_balancer</module> fournit
          des services de r&eacute;partition de charge (load balancing) pour le
	  module <module>mod_proxy</module>.
          Le nouveau module <module>mod_proxy_ajp</module> ajoute le
	  support pour le
          <code>Protocole JServ de Apache version 1.3</code> qu'utilise
          <a href="http://jakarta.apache.org/tomcat/">Apache Tomcat</a>.</dd>

      <dt>Mise &agrave; jour de la biblioth&egrave;que des expressions rationnelles</dt>
      <dd>La version 5.0 de la
          <a href="http://www.pcre.org/">Perl Compatible Regular Expression
          Library</a> (PCRE) est maintenant disponible.
	  <program>httpd</program> peut &ecirc;tre configur&eacute; pour utiliser une
	  PCRE choisie en passant l'option <code>--with-pcre</code> au
	  script configure.</dd>

      <dt>Filtrage intelligent</dt>
      <dd>Le module <module>mod_filter</module> permet la configuration
          dynamique de la cha&icirc;ne de filtrage en sortie. Il permet
	  d'ins&eacute;rer des filtres conditionnels bas&eacute;s sur toute
	  requ&ecirc;te, en-t&ecirc;te de r&eacute;ponse ou variable
	  d'environnement, et fait table rase des probl&egrave;mes de d&eacute;pendances
	  et d'ordonnancement rencontr&eacute;s avec l'architecture 2.0.</dd>

      <dt>Support des gros fichiers</dt>

      <dd><program>httpd</program> supporte maintenant les fichiers d'une taille sup&eacute;rieure
      &agrave; 2GB sur les syst&egrave;mes 32 bits UNIX modernes.  Le support des
      corps de requ&ecirc;te d'une taille sup&eacute;rieure &agrave; 2GB a aussi &eacute;t&eacute;
      ajout&eacute;.</dd>

      <dt>Module MPM Event</dt>
      <dd>Le module MPM <module>event</module> utilise un thread s&eacute;par&eacute;
      	pour g&eacute;rer les requ&ecirc;tes "Keep alive" et accepter des connexions.
	Les requ&ecirc;tes "Keep alive" requ&eacute;raient traditionnellement un
	processus httpd d&eacute;di&eacute; pour leur gestion. Ce processus d&eacute;di&eacute;
	ne pouvait plus &ecirc;tre r&eacute;utilis&eacute; jusqu'&agrave; ce que le d&eacute;lai "Keep Alive"
          soit &eacute;coul&eacute;.</dd>

      <dt>Support des bases de donn&eacute;es SQL</dt>
      <dd>Le module <p><module>mod_dbd</module>, associ&eacute; &agrave; l'environnement
      	<code>apr_dbd</code>, fournit le support SQL direct aux modules
	qui en ont besoin.  Supporte la mise en commun des connexions
          dans les modules MPM thread&eacute;s.</p>
	  </dd>

    </dl>
  </section>

  <section id="module">
    <title>Am&eacute;liorations des modules</title>
    <dl>
      <dt>Authn/Authz</dt>
      <dd>Les modules du r&eacute;pertoire aaa ont &eacute;t&eacute; renomm&eacute;s et fournissent
          un support am&eacute;lior&eacute; pour la m&eacute;thode d'authentification <strong>digest</strong>.  Par exemple, <code>mod_auth</code>
          est maintenant scind&eacute; en deux modules : <module>mod_auth_basic</module> et
          <module>mod_authn_file</module>; <code>mod_auth_dbm</code> s'appelle maintenant
          <module>mod_authn_dbm</module>; <code>mod_access</code> a &eacute;t&eacute; renomm&eacute; en
          <module>mod_authz_host</module>.  Est &eacute;galement apparu le nouveau module
          <module>mod_authn_alias</module> qui simplifie
          certaines configurations d'authentification.
      </dd>

      <dt><module>mod_authnz_ldap</module></dt>
      <dd>Ce module est un portage de la version 2.0 du module
          <code>mod_auth_ldap</code> vers la version 2.2 du framework
	  <code>Authn/Authz</code>.
	  Les nouvelles fonctionnalit&eacute;s comprennent l'utilisation des valeurs
	  d'attributs LDAP et des filtres de recherche avanc&eacute;s dans la
          directive <directive module="core">Require</directive>.</dd>

      <dt><module>mod_authz_owner</module></dt>
      <dd>Ce nouveau module propose une gestion des droits d'acc&egrave;s aux ressources web selon leur appartenance
      &agrave; un utilisateur au niveau du syst&egrave;me de fichiers.</dd>

      <dt><module>mod_version</module></dt>
      <dd>Ce nouveau module permet de d&eacute;finir des blocs de configuration activables selon le num&eacute;ro de version du serveur en fonctionnement.</dd>

      <dt><module>mod_info</module></dt>
      <dd>Un nouvel argument <code>?config</code> a &eacute;t&eacute; ajout&eacute;, qui permettra d'afficher
          les directives de configuration telles qu'elles sont interpr&eacute;t&eacute;es
	  par Apache, y compris le nom de fichier et le num&eacute;ro de ligne.
	  Le module montre aussi l'ordre des point d'entr&eacute;e de traitement d'une
	  requ&ecirc;te (request hooks) ainsi que des informations de construction
	  suppl&eacute;mentaires, d'une mani&egrave;re similaire &agrave; <code>httpd -V</code>.</dd>

      <dt><module>mod_ssl</module></dt>
      <!-- Need Info on SSLEngine Support? -->
      <dd>Le support de <a href="http://www.ietf.org/rfc/rfc2817.txt"
      	>RFC 2817</a>, a &eacute;t&eacute; ajout&eacute;, ce qui permet de passer d'une
	connexion en clair au cryptage TLS.</dd>

      <dt><module>mod_imagemap</module></dt>
      <dd><code>mod_imap</code> a &eacute;t&eacute; renomm&eacute; en <module>mod_imagemap</module> afin
      d'&eacute;viter une confusion pour les utilisateurs.</dd>
    </dl>

  </section>

  <section id="programs">
    <title>Am&eacute;liorations des programmes</title>
    <dl>
      <dt><program>httpd</program></dt>
      <dd>Une nouvelle option de ligne de commande <code>-M</code>
     a &eacute;t&eacute; ajout&eacute;e, qui fournit la liste de tous les modules charg&eacute;s
     en fonction de la configuration r&eacute;elle. &Agrave; la diff&eacute;rence de l'option
     <code>-l</code>, cette liste inclut les Objets Dynamiques Partag&eacute;s
     (DSOs) charg&eacute;s par l'interm&eacute;diaire du module
     <module>mod_so</module>.</dd>
      <dt><program>httxt2dbm</program></dt>
      <dd>Un nouveau programme servant &agrave; g&eacute;n&eacute;rer des fichiers dbm &agrave; partir
      d'une source texte, &agrave; utiliser avec la directive
      <directive module="mod_rewrite">RewriteMap</directive>
          et le type de mise en correspondance <code>dbm</code>.</dd>
    </dl>
  </section>

  <section id="developer">
    <title>Changements pour le d&eacute;veloppeur de module</title>
    <dl>
      <dt><glossary>APR</glossary> 1.0 API</dt>

      <dd>Apache 2.2 utilise l'API APR 1.0.  Toutes les fonctions et
      symboles obsol&egrave;tes ont &eacute;t&eacute; supprim&eacute;s du code de <code>APR</code> et
          <code>APR-Util</code>. Pour plus de d&eacute;tails, consultez le
          <a href="http://apr.apache.org/">site web de APR</a>.</dd>

      <dt>Authn/Authz</dt>
      <dd>Les modules d'authentification et d'autorisation int&eacute;gr&eacute;s ont
          &eacute;t&eacute; renomm&eacute;s de la mani&egrave;re suivante:
          <ul>
          <li><code>mod_auth_*</code>  -> Modules qui impl&eacute;mentent un m&eacute;canisme
	  	d'authentification HTTP</li>
          <li><code>mod_authn_*</code> -> Modules qui fournissent un dispositif
	  	d'authentification en arri&egrave;re-plan</li>
          <li><code>mod_authz_*</code> -> Modules qui impl&eacute;mentent l'autorisation (ou l'acc&egrave;s)</li>
          <li><code>mod_authnz_*</code> -> Module qui impl&eacute;mentent &agrave; la fois
	  l'authentification &amp; l'autorisation</li>
          </ul>
	  L'organisation des m&eacute;thodes d'authentification a &eacute;galement &eacute;t&eacute; revue, ce qui va simplifier
	  grandement l'ajout de nouvelles m&eacute;thodes d'authentification.</dd>

      <dt>Journalisation des erreurs de connexion</dt>

      <dd>Une nouvelle fonction a &eacute;t&eacute; ajout&eacute;e, <code>ap_log_cerror</code>,
      afin de pouvoir enregistrer les erreurs qui surviennent au cours de
      la connexion du client.  Une fois enregistr&eacute;, le message inclut l'adresse IP du client.</dd>

      <dt>Ajout d'une portion de code pour la v&eacute;rification de la configuration</dt>

      <dd>Un nouvel &eacute;l&eacute;ment de traitement a &eacute;t&eacute; ajout&eacute;, <code>test_config</code>,
      afin d'aider les modules qui ne veulent ex&eacute;cuter un code sp&eacute;cial
      que si l'utilisateur passe le param&egrave;tre <code>-t</code> &agrave;
      <program>httpd</program>.</dd>

      <dt>D&eacute;finition de la taille de la pile pour les modules MPM en processus l&eacute;gers</dt>

      <dd>Une nouvelle directive a &eacute;t&eacute; ajout&eacute;e, <directive module="mpm_common"
          >ThreadStackSize</directive>
     afin de d&eacute;finir la taille de la pile pour tous les modules MPM en processus l&eacute;gers (modules thread&eacute;s).
     Ceci s'av&egrave;re n&eacute;cessaire pour certains modules tiers sur des plateformes
     dont la taille de la pile des threads par d&eacute;faut est
     trop petite.</dd>

      <dt>Gestion de protocole pour les filtres en sortie</dt>

      <dd>Par le pass&eacute;, chaque filtre devait s'assurer que les en-t&ecirc;tes de
      r&eacute;ponse corrects &eacute;taient g&eacute;n&eacute;r&eacute;s dans la mesure o&ugrave; il les affectait.
      Les filtres peuvent maintenant d&eacute;l&eacute;guer la gestion courante du
      protocole au module
          <module>mod_filter</module>, &agrave; l'aide des appels
          <code>ap_register_output_filter_protocol</code> ou
          <code>ap_filter_protocol</code>.</dd>

      <dt>Ajout d'un &eacute;l&eacute;ment de traitement pour le processus p&egrave;re (monitor hook)</dt>
      <dd>Ce nouvel &eacute;l&eacute;ment de traitement permet aux modules de lancer
      des jobs r&eacute;guliers/planifi&eacute;s au niveau du processus p&egrave;re
      (root).</dd>

      <dt>Modifications de l'API de traitement des expressions r&eacute;guli&egrave;res</dt>

      <dd>Le fichier d'en-t&ecirc;te <code>pcreposix.h</code> n'est plus disponible;
      il a &eacute;t&eacute; remplac&eacute; par le nouveau fichier
      d'en-t&ecirc;te <code>ap_regex.h</code>.  L'impl&eacute;mentation
      POSIX.2 <code>regex.h</code> expos&eacute;e dans l'ancien fichier d'en-t&ecirc;te
      est maintenant disponible dans l'espace de nommage <code>ap_</code>
      depuis <code>ap_regex.h</code>.  Les appels &agrave; <code>regcomp</code>,
      <code>regexec</code>, etc... peuvent &ecirc;tre remplac&eacute;s par des appels &agrave;
      <code>ap_regcomp</code>, <code>ap_regexec</code>.</dd>

      <dt>Cadre d'application DBD (API pour base de donn&eacute;es SQL)</dt>

      <dd><p>Avec Apache 1.x et 2.0, les modules n&eacute;cessitant un processus
      SQL d'arri&egrave;re-plan devaient s'en charger eux-m&ecirc;mes.  En dehors du fait
      de r&eacute;inventer la roue, ceci peut s'av&eacute;rer tr&egrave;s inefficace, par
      exemple lorsque plusieurs modules maintiennent chacun leurs
      propres connexions.</p>
      <p>Apache 2.1 et sup&eacute;rieur fournissent l'API <code>ap_dbd</code> qui
      permet la gestion des connexions &agrave; la base de donn&eacute;es (y compris
      les strat&eacute;gies optimis&eacute;es pour les modules MPM thread&eacute;s
      et non thread&eacute;s), tandis que APR 1.2 et sup&eacute;rieur fournissent
      l'API <code>apr_dbd</code> qui permet l'interaction avec la
      base de donn&eacute;es.</p>
      <p>Les nouveaux modules DEVRAIENT d&eacute;sormais utiliser ces APIs pour
      toutes les op&eacute;rations li&eacute;es aux bases de donn&eacute;es SQL.
      De m&ecirc;me, les applications existantes DEVRAIENT &ecirc;tre mises &agrave; jour
      lorsque c'est possible, soit de mani&egrave;re transparente ou sous forme
      d'une option recommand&eacute;e &agrave; leurs utilisateurs.</p></dd>
    </dl>
  </section>
</manualpage>
